/** <!------------------------------------------------------------------------->
*
*  @file StateManager_external.h
*
*  @creationDate 12 February 2025 14:57:23
*
*  @brief External definition of a shared state management.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2025, dSPACE GmbH. All rights reserved.
*
*<!-------------------------------------------------------------------------->*/

/* File ID: 6149b397-0c0b-456b-a873-3509a639f366 */
#pragma once

#include <Platform_Types.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern void StateManager_RegisterCallback_SingleTransition(uint32 index, void(*callback)(uint32, uint8, uint8), uint8 expectedOldState, uint8 expectedNewState);
extern void StateManager_RegisterCallback_MultipleTransitions(uint32 index, void(*callback)(uint32, uint8, uint8),uint8 numberOfExpectedTransitions, uint8 someTransition[][2]);
extern void StateManager_RegisterCallback_NoTransitions(uint32 index, void(*callback)(uint32, uint8, uint8));
extern void StateManager_UnregisterCallback_SingleTransition(uint32 index, void(*callback)(uint32, uint8, uint8), uint8 expectedOldState, uint8 expectedNewState);
extern void StateManager_UnregisterCallback_MultipleTransitions(uint32 index, void(*callback)(uint32, uint8, uint8),uint8 numberOfExpectedTransitions, uint8 someTransition[][2]);
extern void StateManager_UnregisterCallback_NoTransitions(uint32 index, void(*callback)(uint32, uint8, uint8));
extern uint8 StateManager_GetState(uint32 index);
extern void StateManager_SetState(uint32 index, uint8 state);
extern void StateManager_DecrementCounterState(uint32 index);
extern void StateManager_ResetCounterState(uint32 index);
extern void StateManager_StateManagerInit(void);
extern void StateManager_SetState_Mutex(uint32 index, uint8 state);
extern void StateManager_GetState_SysIntCodeMap(uint32 index, void* State);

#ifdef __cplusplus
}
#endif /* __cplusplus */ 


